/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audioengines;

import com.sun.j3d.audioengines.AuralParameters;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class Sample {
    protected static final boolean debugFlag = false;
    protected static final boolean internalErrors = false;
    public static final int NULL_SAMPLE = -1;
    protected MediaContainer soundData = null;
    protected int soundType = -1;
    protected float gain = 1.0f;
    protected float rateScaleFactor = 1.0f;
    protected int loopCount = 0;
    public static final int DURATION_UNKNOWN = -1;
    protected long duration = -1L;
    protected int numberOfChannels = 0;
    protected boolean mute = false;
    protected Transform3D vworldXfrm = new Transform3D();
    protected boolean vwXfrmFlag = false;
    protected Point3f position = new Point3f(0.0f, 0.0f, 0.0f);
    protected double[] attenuationDistance = null;
    protected float[] attenuationGain = null;
    protected int dirtyFlags = 65535;
    protected Vector3f direction = new Vector3f(0.0f, 0.0f, 1.0f);
    protected double[] backAttenuationDistance = null;
    protected float[] backAttenuationGain = null;
    protected double[] angularDistance = new double[]{0.0, 1.5707963267948966};
    protected float[] angularGain = new float[]{1.0f, 0.0f};
    public static final int NO_FILTERING = -1;
    public static final int LOW_PASS = 1;
    protected int angularFilterType = -1;
    protected float[] angularFilterCutoff = new float[]{-1.0f, -1.0f};
    protected float obstructionGain = 1.0f;
    protected int obstructionFilterType = -1;
    protected float obstructionFilterCutoff = -1.0f;
    protected float occlusionGain = 1.0f;
    protected int occlusionFilterType = -1;
    protected float occlusionFilterCutoff = -1.0f;

    protected void debugPrint(String string) {
    }

    protected void debugPrintln(String string) {
    }

    public long getDuration() {
        return 0L;
    }

    public long getStartTime() {
        return 0L;
    }

    public int getNumberOfChannelsUsed() {
        return 0;
    }

    public void setDirtyFlags(int n2) {
        this.dirtyFlags = n2;
    }

    public int getDirtyFlags() {
        return this.dirtyFlags;
    }

    public void setSoundType(int n2) {
        this.soundType = n2;
    }

    public int getSoundType() {
        return this.soundType;
    }

    public void setSoundData(MediaContainer mediaContainer) {
        this.soundData = mediaContainer;
    }

    public MediaContainer getSoundData() {
        return this.soundData;
    }

    public void setMuteFlag(boolean bl) {
        this.mute = bl;
    }

    public boolean getMuteFlag() {
        return this.mute;
    }

    public void setVWrldXfrmFlag(boolean bl) {
        this.vwXfrmFlag = bl;
    }

    public boolean getVWrldXfrmFlag() {
        return this.vwXfrmFlag;
    }

    public void setGain(float f2) {
        this.gain = f2;
    }

    public float getGain() {
        return this.gain;
    }

    public void setLoopCount(int n2) {
        this.loopCount = n2;
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public void setPosition(Point3d point3d) {
        this.position.set(point3d);
    }

    public void setDistanceGain(double[] dArray, float[] fArray, double[] dArray2, float[] fArray2) {
        int n2;
        int n3;
        if (dArray != null) {
            n3 = dArray.length;
            this.attenuationDistance = new double[n3];
            this.attenuationGain = new float[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.attenuationDistance[n2] = dArray[n2];
                this.attenuationGain[n2] = fArray[n2];
            }
        } else {
            this.attenuationDistance = null;
            this.attenuationGain = null;
        }
        if (dArray2 != null && dArray != null) {
            n3 = dArray2.length;
            this.backAttenuationDistance = new double[n3];
            this.backAttenuationGain = new float[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.backAttenuationDistance[n2] = dArray2[n2];
                this.backAttenuationGain[n2] = fArray2[n2];
            }
        } else {
            this.backAttenuationDistance = null;
            this.backAttenuationGain = null;
        }
    }

    public void setDirection(Vector3d vector3d) {
        this.direction.set(vector3d);
    }

    public void setAngularAttenuation(int n2, double[] dArray, float[] fArray, float[] fArray2) {
        if (dArray != null) {
            int n3 = dArray.length;
            this.angularDistance = new double[n3];
            this.angularGain = new float[n3];
            this.angularFilterCutoff = (float[])(n2 != -1 && fArray2 != null ? new float[n3] : null);
            for (int i2 = 0; i2 < n3; ++i2) {
                this.angularDistance[i2] = dArray[i2];
                this.angularGain[i2] = fArray[i2];
                if (n2 == -1) continue;
                this.angularFilterCutoff[i2] = fArray2[i2];
            }
            this.angularFilterType = n2;
        } else {
            this.angularDistance = null;
            this.angularGain = null;
            this.angularFilterCutoff = null;
            this.angularFilterType = -1;
        }
    }

    public void setRateScaleFactor(float f2) {
        this.rateScaleFactor = f2;
    }

    public float getRateScaleFactor() {
        return this.rateScaleFactor;
    }

    public void setObstructionGain(float f2) {
        this.obstructionGain = f2;
    }

    public float getObstructionGain() {
        return this.obstructionGain;
    }

    public void setObstructionFilter(float f2) {
        this.obstructionFilterType = 1;
        this.obstructionFilterCutoff = f2;
    }

    public void setOcclusionGain(float f2) {
        this.occlusionGain = f2;
    }

    public float getOcclusionGain() {
        return this.occlusionGain;
    }

    public void setOcclusionFilter(float f2) {
        this.occlusionFilterType = 1;
        this.occlusionFilterCutoff = f2;
    }

    public void clear() {
        this.soundData = null;
        this.soundType = -1;
        this.gain = 1.0f;
        this.loopCount = 0;
        this.duration = -1L;
        this.numberOfChannels = 0;
        this.vworldXfrm.setIdentity();
        this.vwXfrmFlag = false;
        this.position.set(0.0f, 0.0f, 0.0f);
        this.attenuationDistance = null;
        this.attenuationGain = null;
        this.direction.set(0.0f, 0.0f, 1.0f);
        this.backAttenuationDistance = null;
        this.backAttenuationGain = null;
        if (this.angularDistance != null) {
            this.angularDistance[0] = 0.0;
            this.angularDistance[1] = 1.5707963705062866;
        }
        if (this.angularGain != null) {
            this.angularGain[0] = 1.0f;
            this.angularGain[1] = 0.0f;
        }
        this.angularFilterType = -1;
        if (this.angularFilterCutoff != null) {
            this.angularFilterCutoff[0] = -1.0f;
            this.angularFilterCutoff[1] = -1.0f;
        }
        this.obstructionGain = 1.0f;
        this.obstructionFilterType = -1;
        this.obstructionFilterCutoff = -1.0f;
        this.occlusionGain = 1.0f;
        this.occlusionFilterType = -1;
        this.occlusionFilterCutoff = -1.0f;
    }

    public void render(int n2, View view, AuralParameters auralParameters) {
    }
}

